//
//  MCListRow.h
//  ListView
//
//  Created by Mark Onyschuk on 11/05/07.
//  Copyright 2007 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCListRow : NSView <NSCoding> {
	BOOL					_isEnabled;
	BOOL					_isSelected;
	id						_representedObject;
	
	IBOutlet NSButton*		_checkboxButton;
	IBOutlet NSTextField*	_titleTextField;
	IBOutlet NSTextField*	_subtitleTextField;
	IBOutlet NSImageView*	_iconImageView;

	unsigned				_badgeCount;
	IBOutlet NSImageView*	_badgeImageView;
}

#if 0
#pragma mark -
#pragma mark Equality
- (unsigned)hash;
- (BOOL)isEqual:(id)anObject;
#endif

#pragma mark -
#pragma mark Accessors
- (BOOL)isSelected;
- (void)setSelected:(BOOL)aBool;

- (BOOL)isEnabled;
- (void)setEnabled:(BOOL)aBool;

- (id)representedObject;
- (void)setRepresentedObject:(id)anObject;

- (int)state;
- (void)setState:(int)aState;

- (NSString *)title;
- (void)setTitle:(NSString *)aTitle;

- (NSString *)subtitle;
- (void)setSubtitle:(NSString *)aSubtitle;

- (NSImage *)image;
- (void)setImage:(NSImage *)anImage;

- (unsigned)badgeCount;
- (void)setBadgeCount:(unsigned)aCount;

#pragma mark -
#pragma mark Event Handling
- (IBAction)takeStateFrom:(id)sender;

- (void)keyDown:(NSEvent *)theEvent;

#pragma mark -
#pragma mark Drawing
- (BOOL)isOpaque;
- (BOOL)isFlipped;
- (void)drawRect:(NSRect)aRect;

@end

@interface MCListRow (Private)
- (void)setTextColor:(NSColor *)aColor;
- (void)setEnabledStatus:(BOOL)isEnabled;

- (void)updateRowForSelectionAndEnabledStatus;
@end

@interface MCListRowImageView : NSImageView {
	NSImage *_transpImage;
}

@end

